
(* any number of flyways and xbots (real physical, with at least 1 xbot having suffered a tracking error) - GetAllAccidentXbots, RecoverAccidentXbot *)
FUNCTION_BLOCK Example29_recoveryaccident
	(*reset index*)
	IF(Execute = FALSE)THEN
		xbot_index := 0;
		recovering_xbots := 0;
		Done := 0;
	END_IF;

	(*wait until a xbot has suffered a tracking error*)
	PMC_ReadNumAccidentXbots1(PM_Controller := PM_Controller,Enable := Execute);
	num_accident := PMC_ReadNumAccidentXbots1.nXbots;
	IF(num_accident > 0)THEN
		recovering_xbots := TRUE;
	END_IF;
	
	(*get IDs of all xbots that have suffered tracking errors*)
	PMC_GetAllAccidentXbots1(PM_Controller := PM_Controller,Execute := recovering_xbots);

	(*recover one of the accident xbots*)
	PMC_RecoverAccidentXbot1(PM_Controller := PM_Controller,Execute := PMC_GetAllAccidentXbots1.Done,XbotID := PMC_GetAllAccidentXbots1.XbotIDs[xbot_index],RecoveryMode := 0,ShortAxis := 0);

	(*reset recover_accident function block and increment the index if it is done and not all accident xbots have been recovered *)
	IF(PMC_RecoverAccidentXbot1.Done)THEN
		IF(xbot_index + 1 < PMC_GetAllAccidentXbots1.nXbots)THEN
			xbot_index := xbot_index + 1;
			PMC_RecoverAccidentXbot1(PM_Controller := PM_Controller,Execute := FALSE,XbotID := PMC_GetAllAccidentXbots1.XbotIDs[xbot_index],RecoveryMode := 0,ShortAxis := 0);
		ELSE
			Done := TRUE;
		END_IF;
	END_IF;
END_FUNCTION_BLOCK
